<?php

/**

 * Christmas Lights

 * Jeremiah Johnson

 * http://jwjdev.com/

 */


if(!defined("IN_MYBB"))

{
    
die("You Cannot Access This File Directly");

}



$plugins->add_hook('admin_config_settings_change_commit', 'christmas_lights_admin_config_settings_change_commit');



function christmas_lights_info()

{

return array(

        "name"  => "هاك الاحتفال بالكريسماس",

        "description"=> "يظهر مظهر جمالي احتفالي اعلي المنتدي",

        "website"        => "http://jwjdev.com/",
        "author"        => "Jeremiah Johnson",

        "authorsite"    => "http://jwjdev.com/",
        "version"        => "1.1",

        "guid"             => "7b59857c971109d00621935a2a628752",
        "compatibility" => "16*"

    );

}



function christmas_lights_is_installed()

{

   global $db;

 
   $query = $db->simple_select("settinggroups", "name", "name='christmas_lights'");


    
   $result = $db->fetch_array($query);


   if($result) {

	return 1;

   } else {

	return 0;

   }
	

}



function christmas_lights_install()
{
	
   global $db;

   $setting_group = array(

		'gid'			=> 'NULL',

		'name'			=> 'christmas_lights',

		'title'			=> 'هاك الاحتفال بالكريسماس',

		'description'	=> 'اعدادات الهاك.',

		'disporder'		=> "1",
		'isdefault'		=> 'no',

	);



   $db->insert_query('settinggroups', $setting_group);


   $gid = $db->insert_id();


	
   $myplugin_setting = array(

		'name'			=> 'christmas_lights_smashable',

		'title'			=> 'تفعيل / تعطيل',

		'description'	=> 'تستطيع تفعيل او تعطيل الهاك من هنا',

		'optionscode'	=> 'yesno',

		'value'			=> '1',

		'disporder'		=> 1,

		'gid'			=> intval($gid),

	);



   $db->insert_query('settings', $myplugin_setting);



   rebuild_settings();

}



function christmas_lights_activate() 
{

	//setup templates

	require_once MYBB_ROOT.'/inc/adminfunctions_templates.php';


	find_replace_templatesets(

		"header",

		'#'.preg_quote('<div id="container">').'#',

		'<div id="container">
<link rel="stylesheet" media="screen" href="http://xserverx.com/forums/inc/lights/christmaslights.css" />
<script type="text/javascript" src="http://xserverx.com/forums/inc/lights/soundmanager2-nodebug-jsmin.js"></script>
<script type="text/javascript" src="http://yui.yahooapis.com/combo?2.6.0/build/yahoo-dom-event/yahoo-dom-event.js&2.6.0/build/animation/animation-min.js"></script>
<script type="text/javascript" src="http://xserverx.com/forums/inc/lights/christmaslights.js.php?bburl={$mybb->settings[\'bburl\']}"></script>
<script type="text/javascript">
var urlBase = \'./\';
soundManager.url = \'./\';
</script>
<div id="lights" class="lightsActive"  onclick="makeInact()"></div>'

	);


}



function christmas_lights_deactivate() 
{

	require_once MYBB_ROOT.'/inc/adminfunctions_templates.php';

	//repair templates

	find_replace_templatesets(
		"header",

		'#'.preg_quote('
<link rel="stylesheet" media="screen" href="http://xserverx.com/forums/inc/lights/christmaslights.css" />
<script type="text/javascript" src="http://xserverx.com/forums/inc/lights/soundmanager2-nodebug-jsmin.js"></script>
<script type="text/javascript" src="http://yui.yahooapis.com/combo?2.6.0/build/yahoo-dom-event/yahoo-dom-event.js&2.6.0/build/animation/animation-min.js"></script>
<script type="text/javascript" src="http://xserverx.com/forums/inc/lights/christmaslights.js.php?bburl={$mybb->settings[\'bburl\']}"></script>
<script type="text/javascript">
var urlBase = \'./\';
soundManager.url = \'./\';
</script>
<div id="lights" class="lightsActive"  onclick="makeInact()"></div>').'#',
		''
	);


	find_replace_templatesets(
		"header",
		'#'.preg_quote('
<link rel="stylesheet" media="screen" href="http://xserverx.com/forums/inc/lights/christmaslights.css" />
<script type="text/javascript" src="http://xserverx.com/forums/inc/lights/soundmanager2-nodebug-jsmin.js"></script>
<script type="text/javascript" src="http://yui.yahooapis.com/combo?2.6.0/build/yahoo-dom-event/yahoo-dom-event.js&2.6.0/build/animation/animation-min.js"></script>
<script type="text/javascript" src="http://xserverx.com/forums/inc/lights/christmaslights.js.php?bburl={$mybb->settings[\'bburl\']}"></script>
<script type="text/javascript">
var urlBase = \'./\';
soundManager.url = \'./\';
</script>
<div id="lights" class="lightsInactive"></div>').'#',

		''

	);


}


function christmas_lights_uninstall()

{

	global $db;

	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name IN ('christmas_lights_smashable')");

	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='christmas_lights'");

	rebuild_settings(); 

}



function christmas_lights_admin_config_settings_change_commit()

{

   global $mybb;

   require_once MYBB_ROOT.'/inc/adminfunctions_templates.php';


   if(!$mybb->settings['christmas_lights_smashable']) { //if they want smashable off

		find_replace_templatesets(
			"header",

			'#'.preg_quote('<div id="lights" class="lightsActive"  onclick="makeInact()">').'#',
			'<div id="lights" class="lightsInactive">');

   }



   if($mybb->settings['christmas_lights_smashable']) { //if they want smashable on

		find_replace_templatesets(

			"header",

			'#'.preg_quote('<div id="lights" class="lightsInactive">').'#',
			'<div id="lights" class="lightsActive"  onclick="makeInact()">');

   }

}


?>